### Satisfaction with Democracy: When Government by the People brings Electoral Losers and Winners Together
# Code Lucas Leemann and Isabelle Stadelmann-Steffen
# First version: December 2018
# Final version: April 2021








############################
# Practice Potential PP
# E: Existence: does an institutions exist
# S: Signature rquirement as share of citizens
# CT: circulation time, square root of annual fraction, never larger than 1...3 months is 1/4 year and is then CT==1/2

#       PP <- E * (1-S) * CT


############################
# Effectiveness Potential
# SQS: Status Quo Surface: A (complicated) way of computing how difficult it is due to Quorums (we do not need it?)
# AQ: Administrative quorums -- double majority
# AQ=0.5 + (1-RD)/2 whereas RD represents the fraction of the required districts for approval

#       EP <- (1-SQS)/0.5 * AQ

############################
# Decisiveness
# If binding D=1, if not binding D=0.75
#       D


############################
# Credible Threat
# T: Measures whether citizen initiated things occur, first five years 1, after 0.06 deduction per year
#       Tr 



#######################################
# DD Index

#       DD.index <- (PP+EP)*D*T  # for citizen initiated ref/init
#       DD.index <- (PP+EP)*D     # for mandatory ref and plebiscite

# add over all four forms (ref, init, mand ref, and plebiscite) - range: 0-8 and then divide by 8.

# inst= 1 citizen initiated ref
# inst= 2 citizen initiated init
# inst= 3 mandatory ref
# inst= 4 Recall


#     E, S, CT, RD, D, Year.of.last.use
# E                 Does the institution exist
# S                 Signature requirement
# CT                circulation time, square root of annual fraction, never larger than 1...3 months is 1/4 year and is then CT==1/2
# RD                RD represents the fraction of the required districts for approval (usually 0)
# D                 If binding D=1, if not binding D=0.75  
# Year.of.last.use  Year of last use of this institution (Measures whether citizen initiated things occur, first five years 1, after 0.06 deduction per year)
# SQS               0.5 for all units except those with particiaption quorums/approval quorum(%of eligible people have to say yes - veto in 19th century in lucerne)/supermajorities -- see Altmann p. 21 on how to calcualte

#CH.init.2010 <- rbind(c(1,0.0069,180,0,1,2010,0.5),c(1,0.0212,180,0,1,2010,0.5))

DD.index <- function(x, inst=1, year, polity.names, threat=1){
  x <- as.matrix(x)
  if(dim(x)[2]==1) x <- t(x)
  if (inst==1|inst==2|inst==4){
    E <- as.numeric(x[,1])
    S <- as.numeric(x[,2])
    CT.d <- as.numeric(as.matrix(x[,3]))
    CT <- CT.d/365
    CT[CT>1] <- 1
    CT <- suppressWarnings(sqrt(CT))
    PP <- E * (1-S) * CT
    RD <- as.numeric(x[,4])
    D <-  as.numeric(x[,5])
    YoL <- as.numeric(x[,6])
    SQS <- as.numeric(x[,7])
    #  AQ <- x[,8]
    AQ <- 0.5 + (1-RD)/2
    #  SQS <- 0 # as long as we only have cases w/o a Quroum
    EP <-  (1-SQS)/0.5 * AQ
    if(missing(year)) year <- as.numeric(format(Sys.Date(),'%Y'))
    cY <- year
    year.delta <- as.matrix(YoL) - cY
    year.delta[abs(year.delta)<=5,] <- 1
    deduction <- (abs(year.delta[abs(year.delta)>5,])-5)
    year.delta[abs(year.delta)>5,] <- 1-0.06*deduction
    year.delta[ year.delta<0] <- 0
    Tr <- year.delta
    if (threat!=1) Tr <- 1
    DD.index1 <- as.matrix((PP+EP)*D*Tr)
  }
  if (inst==3){
    E <- as.numeric(x[,1])
    SQS <- as.numeric(x[,2])
    RD <- as.numeric(x[,3])
    AQ <- 0.5 + (1-RD)/2
    EP <- (1-SQS)/0.5 * AQ
    DD.index1 <- as.matrix((EP))
  }
  if(!missing(polity.names)) rownames(DD.index1) <- polity.names
  DD.index1[E==0,] <- 0 # for cases where the institution does not exist
  #print(DD.index1)
  return(DD.index1)
}




USdata.init <- read_xlsx("Data/DD_data/US/Maria DD US_ACO.xlsx",
                   sheet = "Initiative 2016 final", range="A1:K34",
                   col_names=TRUE)

USdata.ref <- read_xlsx("Data/DD_data/US/Maria DD US_ACO.xlsx",
                         sheet = "Referendum 2016 final", range="A1:K34",
                         col_names=TRUE)

USdata.ManRef <- read_xlsx("Data/DD_data/US/Masoud DD US.xlsx",
                        sheet = "Mandatory Referendum", range="A7:G57",
                        col_names=TRUE)

USdata.rec <- read_xlsx("Data/DD_data/US/Maria DD US_ACO.xlsx",
                        sheet = "Recall", range="A3:K22",
                        col_names=TRUE)

USdata.init <- as.data.frame(USdata.init)
USdata.ref <- as.data.frame(USdata.ref)
USdata.ManRef <- as.data.frame(USdata.ManRef)
USdata.rec <- as.data.frame(USdata.rec)


head(USdata.init)
head(USdata.ref)

# E                 Does the institution exist
# S                 Signature requirement
# CT                circulation time, square root of annual fraction, never larger than 1...3 months is 1/4 year and is then CT==1/2
# RD                RD represents the fraction of the required districts for approval (usually 0)
# D                 If binding D=1, if not binding D=0.75  
# Year.of.last.use  Year of last use of this institution (Measures whether citizen initiated things occur, first five years 1, after 0.06 deduction per year)
# SQS               0.5 for all units except those with particiaption quorums/approval quorum(%of eligible people have to say yes - veto in 19th century in lucerne)/supermajorities -- see Altmann p. 21 on how to calcualte

# for inst= 1 or 2 or 4
########################
# E 1st column
# S 2nd column
# CT 3rd column
# RD 4th column
# D 5th column
# YoL 6th column
# SQS 7th column

# for inst= 3
########################
# E 1st column
# SQS 2nd column
# RD 3rd column


USdata.init1 <- cbind(USdata.init[,3],as.numeric(USdata.init[,6]),as.numeric(USdata.init[,7]),USdata.init[,8],USdata.init[,9],USdata.init[,10],USdata.init[,11])
USdata.ref1 <- cbind(USdata.ref[,3],as.numeric(USdata.ref[,6]),as.numeric(USdata.ref[,7]),USdata.ref[,8],USdata.ref[,9],USdata.ref[,10],USdata.ref[,11])
USdata.ManRef1 <- cbind(USdata.ManRef[,5],USdata.ManRef[,6],USdata.ManRef[,7])
USdata.rec1 <- cbind(USdata.rec[,2],as.numeric(USdata.rec[,7]),as.numeric(USdata.rec[,3]),USdata.rec[,8],USdata.rec[,9],USdata.rec[,10],USdata.rec[,11])


# E                 Does the institution exist
# S                 Signature requirement
# CT                circulation time, square root of annual fraction, never larger than 1...3 months is 1/4 year and is then CT==1/2
# RD                RD represents the fraction of the required districts for approval (usually 0)
# D                 If binding D=1, if not binding D=0.75  
# Year.of.last.use  Year of last use of this institution (Measures whether citizen initiated things occur, first five years 1, after 0.06 deduction per year)
# SQS   

Init.US.2016 <- DD.index(x = USdata.init1, inst=1,year=2016,polity.names=USdata.init[,1])
Init.US.2016_nt <- DD.index(x = USdata.init1, inst=1,year=2016,polity.names=USdata.init[,1], threat=0)

Ref.US.2016 <- DD.index(x = USdata.ref1, inst=2,year=2016,polity.names=USdata.ref[,1])
Ref.US.2016_nt <- DD.index(x = USdata.ref1, inst=2,year=2016,polity.names=USdata.ref[,1], threat=0)

ManRef.US.2016 <- DD.index(x = USdata.ManRef1, inst=3, year=2016, polity.names=USdata.ManRef[,1])

Rec.US.2016 <- DD.index(x = USdata.rec1, inst=4,year=2016,polity.names=USdata.rec[,1])
Rec.US.2016_nt <- DD.index(x = USdata.rec1, inst=4,year=2016,polity.names=USdata.rec[,1], threat=0)

#####################
#####################

ManRef.US.2016 <- data.frame(rownames(ManRef.US.2016),ManRef.US.2016)
colnames(ManRef.US.2016) <- c("State","ManRef")

all.state.names <- levels(ManRef.US.2016$State)

Init.US.2016 <- data.frame(rownames(Init.US.2016),Init.US.2016)
colnames(Init.US.2016) <- c("State","Init")
Init.US.2016$Init_nt <- c(Init.US.2016_nt)

Ref.US.2016 <- data.frame(rownames(Ref.US.2016),Ref.US.2016)
colnames(Ref.US.2016) <- c("State","Ref")
Ref.US.2016$Ref_nt <- c(Ref.US.2016_nt) 

Rec.US.2016 <- data.frame(rownames(Rec.US.2016),Rec.US.2016)
colnames(Rec.US.2016) <- c("State","Rec")
Rec.US.2016$Rec_nt <- c(Rec.US.2016_nt)


# Create US Data Matrix

US.DD.data <- full_join(ManRef.US.2016, Init.US.2016, by = "State")
US.DD.data <- full_join(US.DD.data, Ref.US.2016, by = "State")
US.DD.data <- full_join(US.DD.data, Rec.US.2016, by = "State")

US.DD.data[is.na(US.DD.data)] <- 0

US.DD.data$mean <- rowMeans(US.DD.data[,c(2,3,5,7)])
US.DD.data$mean_nt <- rowMeans(US.DD.data[,c(2,4,6,8)])

names(US.DD.data)[9] <- "Average"
names(US.DD.data)[10] <- "Average_nt"

# add DD_use (2010-2014/2015)
ddu <- read_xlsx("Data/DD_data/DDuse.xlsx",
                 sheet = "Tabelle1", range="A1:C104",
                 col_names=TRUE)
ddu <- ddu[ddu$country=="US",]

US.DD.data$Usage <- ddu$DDuse
save(US.DD.data,file = "Output/Data/IndexUS.Rdata")



################################################################################
################################################################################
# Swiss Data


CHdata.ManRef <- read.csv("Data/DD_data/CH/ManRefCH2016.csv",
                         header=TRUE)
CHdata.ManRef <- CHdata.ManRef[,-1]


CHdata.init <- read.csv("Data/DD_data/CH/InitCH2016.csv",
                        header=TRUE)
CHdata.init <- CHdata.init[,-1]

CHdata.ref <- read.csv("Data/DD_data/CH/OptRefCH2016.csv",
                        header=TRUE)
CHdata.ref <- CHdata.ref[,-1]

canton.name <- CHdata.ref[,7]


CHdata.init1 <- data.frame(CHdata.init[,-7],0.5)
CHdata.ref1 <- data.frame(CHdata.ref[,-7],0.5)
CHdata.ManRef1 <- data.frame(CHdata.ManRef[,1],0,0)

Init.CH.2016 <- data.frame(DD.index(x = CHdata.init1, inst=1,year=2016,polity.names=canton.name))
Init.CH.2016_nt <- data.frame(DD.index(x = CHdata.init1, inst=1,year=2016,polity.names=canton.name, threat=0))

Ref.CH.2016 <- data.frame(DD.index(x = CHdata.ref1, inst=2,year=2016,polity.names=canton.name))
Ref.CH.2016_nt <- data.frame(DD.index(x = CHdata.ref1, inst=2,year=2016,polity.names=canton.name, threat=0))


# for AI and GL fix that opt ref is always threat although not recorded
Ref.CH.2016[25:26,1] <- Ref.CH.2016_nt[25:26,1] 



ManRef.CH.2016 <- data.frame(DD.index(x = CHdata.ManRef1, inst=3,year=2016,polity.names=canton.name))
Rec.CH.2016 <- ManRef.CH.2016
Rec.CH.2016[,1] <- rep(0,26) # da keine erfolgreichen recalls in den letzten 20 jahren
names(Init.CH.2016) <- "Init"
Init.CH.2016$Init_nt <- c(Init.CH.2016_nt[,1])
names(Ref.CH.2016) <- "Ref"
Ref.CH.2016$Ref_nt <-  c(Ref.CH.2016_nt[,1])
names(ManRef.CH.2016) <- "ManRef"
names(Rec.CH.2016) <- "Rec"
Rec.CH.2016$Rec_nt <- 0

Init.CH.2016$State <- canton.name
Ref.CH.2016$State <- canton.name
ManRef.CH.2016$State <- canton.name
Rec.CH.2016$State <- canton.name

CH.DD.data <- full_join(Init.CH.2016,Ref.CH.2016, by="State")
CH.DD.data <- full_join(CH.DD.data,ManRef.CH.2016, by="State")
CH.DD.data <- full_join(CH.DD.data,Rec.CH.2016, by="State")
CH.DD.data <- data.frame(CH.DD.data[,3],CH.DD.data[,-3])
names(CH.DD.data)[1] <- "State"

CH.DD.data$mean <- rowMeans(CH.DD.data[,c(2,4,6,7)])
CH.DD.data$mean_nt <- rowMeans(CH.DD.data[,c(3,5,6,8)], na.rm = TRUE)

names(CH.DD.data)[9] <- "Average"
names(CH.DD.data)[10] <- "Average_nt"

Stutzer <- read_xlsx("Data/DD_data/CH/Stutzer-Index_NEUjan18_1.xlsx",
                     sheet = "Direktdemokratische Rechte", range="AC4:AD28",
                     col_names=TRUE)

names(Stutzer) <- c("StutzerOHNE", "StutzerMIT")

CH.DD.data$StutzerOHNE <- NA
CH.DD.data$StutzerOHNE[1:24] <- Stutzer$StutzerOHNE

CH.DD.data$StutzerMIT <- NA
CH.DD.data$StutzerMIT[1:24] <- Stutzer$StutzerMIT


# add DD_use (2010-2014/2015)
ddu <- read_xlsx("Data/DD_data/DDuse.xlsx",
                 sheet = "Tabelle1", range="A1:C104",
                 col_names=TRUE)
ddu <- ddu[ddu$country=="CH",]
ddu.sort <- ddu[c(1,9,23,22,4,21,20,5,11,14,17,24,3,26,18,25,10,12,13,2,19,6,7,15,16,8),]

CH.DD.data$Usage <- ddu$DDuse
save(CH.DD.data,file = "Output/Data/IndexCH.Rdata")




################################################################################
################################################################################
# Austrian Data

ATdata.ref <- read_excel("Data/DD_data/AT/1_Optional Subnational DD Austria.xlsx")
ATdata.ref1 <- data.frame(ATdata.ref[,2], ATdata.ref[,5], ATdata.ref[,6],ATdata.ref[,7], ATdata.ref[,9], ATdata.ref[,10], ATdata.ref[,1])


ATdata.Manref <- read_excel("Data/DD_data/AT/1_Obligatory Subnational DD Austria.xlsx")
ATdata.Manref1 <- data.frame(ATdata.Manref[,2], ATdata.Manref[,3], ATdata.Manref[,4],ATdata.Manref[,5], ATdata.Manref[,7], ATdata.Manref[,8], ATdata.Manref[,1])

ATdata.init <- read_excel("Data/DD_data/AT/1_Volksbegehren Subnational DD Austria.xlsx")
ATdata.init1 <- data.frame(ATdata.init[,2], ATdata.init[,5], ATdata.init[,6],ATdata.init[,7], ATdata.init[,9], ATdata.init[,10], ATdata.init[,1])
ATdata.init1 <- ATdata.init1[-c(6,10),]

state.name <- ATdata.ref[,1]
state.name.init <- ATdata.init[-c(6,10),1]


ATdata.init2 <- data.frame(ATdata.init1[,-7],0.5)
ATdata.ref2 <- data.frame(ATdata.ref1[,-7],0.5)
ATdata.ManRef2 <- data.frame(ATdata.Manref1[,1],0,0)


Init.AT.2016 <- data.frame(DD.index(x = ATdata.init2, inst=1,year=2016,polity.names=state.name.init$state))
Init.AT.2016_nt <- data.frame(DD.index(x = ATdata.init2, inst=1,year=2016,polity.names=state.name.init$state, threat=0))

Ref.AT.2016 <- data.frame(DD.index(x = ATdata.ref2, inst=2,year=2016,polity.names=state.name$state))
Ref.AT.2016_nt <- data.frame(DD.index(x = ATdata.ref2, inst=2,year=2016,polity.names=state.name$state, threat=0))

ManRef.AT.2016 <- data.frame(DD.index(x = ATdata.ManRef2, inst=3,year=2016,polity.names=state.name$state))

Rec.AT.2016 <- ManRef.AT.2016
Rec.AT.2016[,1] <- rep(0,9) # da keine erfolgreichen recalls in den letzten 20 jahren



names(Init.AT.2016) <- "Init"
Init.AT.2016$Init_nt <- c(Init.AT.2016_nt[,1])

names(Ref.AT.2016) <- "Ref"
Ref.AT.2016$Ref_nt <- c(Ref.AT.2016_nt[,1])

names(ManRef.AT.2016) <- "ManRef"

names(Rec.AT.2016) <- "Rec"
Rec.AT.2016$Rec_nt <- 0


Init.AT.2016$State <- state.name.init$state
Ref.AT.2016$State <- state.name$state
ManRef.AT.2016$State <- state.name$state
Rec.AT.2016$State <- state.name$state

AT.DD.data <- full_join(Init.AT.2016,Ref.AT.2016, by="State")
AT.DD.data <- full_join(AT.DD.data,ManRef.AT.2016, by="State")
AT.DD.data <- full_join(AT.DD.data,Rec.AT.2016, by="State")
AT.DD.data <- data.frame(AT.DD.data[,3],AT.DD.data[,-3])
names(AT.DD.data)[1] <- "State"

AT.DD.data$mean <- rowMeans(AT.DD.data[,c(2,4,6,7)])
AT.DD.data$mean_nt <- rowMeans(AT.DD.data[,c(3,5,6,8)])
names(AT.DD.data)[9] <- "Average"
names(AT.DD.data)[10] <- "Average_nt"
AT.DD.data$Usage <- 0
save(AT.DD.data,file = "Output/Data/IndexAT.Rdata")


################################################################################
################################################################################
# German Data


DEdata.ManRef <- read.csv("Data/DD_data/GE/Oblig Ref.csv",
                          header=TRUE)
DEdata.ManRef <- DEdata.ManRef[,c(1:7)]
DEdata.ManRef <- DEdata.ManRef[-which(is.na(DEdata.ManRef$Exist)),]


DEdata.init <- read.csv("Data/DD_data/GE/Volksinitiative.csv",
                        header=TRUE, nrows = 17, strip.white = TRUE)
DEdata.init <- DEdata.init[c(1:16),c(1:16)]


DEdata.ref <- read.csv("Data/DD_data/GE/Fak Ref.csv",
                       header=TRUE)
DEdata.ref <- DEdata.ref[c(1:16),c(1:8)]

names(CHdata.init1)
names(DEdata.init)

DEdata.init1 <- DEdata.init[,c(1,2,3,4,5,6,7,8)]
DEdata.init1[,2] <- DEdata.init1[,2]/100
for (i in 1:16){
  NAticker <- is.na(DEdata.init1[i,3])
  if (!NAticker){
    DEdata.init1[i,3] <- max(DEdata.init1[i,3],DEdata.init1[i,4])
  }
  if (NAticker){
    DEdata.init1[i,3] <- DEdata.init1[i,4]
  }
}

# pre-processing init
DEdata.init1 <- DEdata.init1[,-4]
DEdata.init1 <- DEdata.init1[,-5]
DEdata.init1$X0.5 <- 0.5
# pre-processing opt ref
DEdata.ref1 <- DEdata.ref[,-c(5,8)]
DEdata.ref1$X0.5 <- 0.5
# pre-processing mandatory fak
DEdata.ManRef1 <- as.matrix(DEdata.ManRef[,1:2])
DEdata.ManRef1 <- cbind(DEdata.ManRef1, 0)
namesL <- as.character(DEdata.ref[1:16,8])
colnames(DEdata.ManRef1)[3] <- "X0.1"

Init.DE.2016 <- data.frame(DD.index(x = DEdata.init1, inst=1,year=2016,polity.names=as.character(DEdata.init[1:16,9])))
Init.DE.2016_nt <- data.frame(DD.index(x = DEdata.init1, inst=1,year=2016,polity.names=as.character(DEdata.init[1:16,9]), threat = 0))

Ref.DE.2016 <- data.frame(DD.index(x = DEdata.ref1, inst=2,year=2016,polity.names=as.character(DEdata.ref[1:16,8])))
Ref.DE.2016_nt <- data.frame(DD.index(x = DEdata.ref1, inst=2,year=2016,polity.names=as.character(DEdata.ref[1:16,8]), threat = 0))

ManRef.DE.2016 <- data.frame(DD.index(x = DEdata.ManRef1, inst=3,year=2016, polity.names=namesL))
Rec.DE.2016 <- data.frame(as.matrix(rep(0,16))) # da keine erfolgreichen recalls in den letzten 20 jahren
rownames(Rec.DE.2016) <- namesL

names(Init.DE.2016) <- "Init"
Init.DE.2016$Init_nf <- c(Init.DE.2016_nt[,1])

names(Ref.DE.2016) <- "Ref"
Ref.DE.2016$Ref_nt <- c(Ref.DE.2016_nt[,1])

names(ManRef.DE.2016) <- "ManRef"
names(Rec.DE.2016) <- "Rec"
Rec.DE.2016$Rec_nt <- 0

bl.names <- namesL
bl.names[1] <- "Baden-Wurttemberg"
bl.names[16] <- "Thuringen"
bl.names[8] <- "Mecklenburg-Vorpommern"

Init.DE.2016$State <- bl.names
Ref.DE.2016$State <- bl.names
ManRef.DE.2016$State <- bl.names
Rec.DE.2016$State <- bl.names

DE.DD.data <- full_join(Init.DE.2016,Ref.DE.2016, by="State")
DE.DD.data <- full_join(DE.DD.data,ManRef.DE.2016, by="State")
DE.DD.data <- full_join(DE.DD.data,Rec.DE.2016, by="State")
DE.DD.data <- data.frame(DE.DD.data[,3],DE.DD.data[,-3])
names(DE.DD.data)[1] <- "State"


DE.DD.data$mean <- rowMeans(DE.DD.data[,c(2,4,6,7)])
DE.DD.data$mean_nt <- rowMeans(DE.DD.data[,c(3,5,6,8)])

names(DE.DD.data)[9] <- "Average"
names(DE.DD.data)[10] <- "Average_nt"

# add DD_use (2010-2014/2015)
ddu <- read_xlsx("Data/DD_data/DDuse.xlsx",
                 sheet = "Tabelle1", range="A1:C104",
                 col_names=TRUE)
ddu <- ddu[ddu$country=="DE",]
ddu.sort <- ddu[c(8,9,11,12,4,2,6,13,3,5,7,10,14,15,1,16),]

DE.DD.data$Usage <- ddu.sort$DDuse
save(DE.DD.data,file = "Output/Data/IndexDE.Rdata")






##########################################################################################
##########################################################################################
##########################################################################################
##########################################################################################

# Combining all countries

US.DD.data$StutzerMIT <- NA
US.DD.data$StutzerOHNE <- NA
DD.data <- rbind(CH.DD.data,US.DD.data)

DD.data$country <- "US"
DD.data$country[1:26] <- "CH"

# adding DE
DE.DD.data$StutzerMIT <- NA
DE.DD.data$StutzerOHNE <- NA
DE.DD.data$country <- "DE"
DE.DD.data <- data.frame(DE.DD.data[,1:10],DE.DD.data[,13],DE.DD.data[,12],DE.DD.data[,11],DE.DD.data[,14])
colnames(DE.DD.data) <- colnames(DD.data)
DD.data <- rbind(DD.data,DE.DD.data)

# adding AT
AT.DD.data$StutzerMIT <- NA
AT.DD.data$StutzerOHNE <- NA
AT.DD.data$country <- "AT"
DD.data <- rbind(DD.data,AT.DD.data)








##########################################################################################
##########################################################################################
##########################################################################################
##########################################################################################






DD.data$unitID <- NA
DD.data$unitID[1:26] <- 100+c(1,9,23,22,4,21,20,5,11,14,17,24,3,26,18,25,10,12,13,2,19,6,7,15,16,8)
DD.data$unitID[27:76] <- 300+c(1,2,4,5,6,8,9,10,12,13,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,44,45,46,47,48,49,50,51,53,54,55,56)
DD.data$unitID[77:92] <- 400+c(1:16)
DD.data$unitID[93:101] <- 200+c(1,2,3,4,5,6,7,8,9)
## Read in level 2 data

Gall_ch <- read.dta("Data/Gallagher/GallagherCH1.dta")
Gall_us <- read.dta( "Data/Gallagher/GallagherUS.dta")
Gall_at <- read_excel("Data/Gallagher/GallagherAT.xlsx")


# Read in government proportion (share of votes for parties 
#in legislative election that are in government)

propDE <- read_xlsx("Data/Gallagher/Measures DE.xlsx",
                     sheet = "Sheet1", range="A1:B16",
                     col_names=FALSE)
propDE <- propDE[c(8,9,11,12,4,2,6,13,3,5,7,10,14,15,1,16),]

propAT <- read_xlsx("Data/Gallagher/Copy of Measures Nadine AT.xlsx",
                    sheet = "Sheet2", range="A1:B9",
                    col_names=FALSE)

propCH <- read_xlsx("Data/Gallagher/Measures Nadine Switzerland1.xlsx",
                    sheet = "Sheet1", range="A1:B26",
                    col_names=FALSE)

propCH <- propCH[c(1,9,23,22,4,21,20,5,11,14,17,24,3,26,18,25,10,12,13,2,19,6,7,15,16,8),]

propUS <- read_xlsx("Data/Gallagher/Measures Nadine USA.xlsx",
                    sheet = "Anteil Waehler in Exekutive", range="B3:C52",
                    col_names=FALSE)

propUS <- as.data.frame(propUS)




DD.data$VoterProp <- NA

DD.data$VoterProp[DD.data$country=="CH"] <- as.numeric(unlist(propCH[,2]))
DD.data$VoterProp[DD.data$country=="AT"] <- as.numeric(unlist(propAT[,2]) )
DD.data$VoterProp[DD.data$country=="DE"] <- as.numeric(unlist(propDE[,2]) )
DD.data$VoterProp[DD.data$country=="US"] <- as.numeric(unlist(propUS[,2]) ) * 100


DD.data$snDDI <- (DD.data$Ref + DD.data$Init + DD.data$ManRef)/3
DD.data$snDDInt <- (DD.data$Ref_nt + DD.data$Init_nt + DD.data$ManRef)/3





save(DD.data,file = "Output/Data/IndexUSCHATDE.Rdata")


#### Plots



colL <- rev(RColorBrewer::brewer.pal(4, "PuOr"))
colL <- alpha(colL,alpha=0.9)

jpeg(file = "Output/Tables and Plots/Fig_A6.jpeg",   # The directory you want to save the file in
    width = 800, # The width of the plot in inches
    height = 400) #

par(family="CMU Serif", mai=c(1,1,0.5,0.5), oma=c(1,1,1,1))
y.st <- c(6,6,5,5,4,4,3,3,2,2,1,1)
x.st <- c(0,.01,.01,.02,.02,.03,.03,.04,.04,.05,.05,.09)
plot(x.st,y.st, type="l", ylab="Stutzer Index Contribution (0-6)", 
     xlab="Required Signatures for an Initiative", bty="n", lwd=4,
     ylim=c(0,6), col=colL[1])
axis(side = 4, at = round(c(0:6),2), col=colL[2], 
     labels = c(0.0,.17, .33,.5,.67,.83,1.00), col.axis=colL[2])
x <- seq(0,.09,length.out=10)
y.ddi <- 6*(1-x)
points(x,y.ddi,type="l", col=colL[3], lwd=4)
x <- seq(0,.09,length.out=10)
y.ddiNEW <- 0.06/(.5*x+0.01)
points(x,y.ddiNEW,type="l", col=colL[4], lwd=4)
legend(0.05,5,col=c(colL[3],colL[1],colL[4]), 
       legend = c("Signature Altman (2015)", "Signature Stutzer (1999)", "Signature Component of snDDI"), 
       lty = 1, lwd=4, bty="n")
dev.off()









DD.data$Index <- (DD.data$Ref + DD.data$Init + DD.data$ManRef)/3



jpeg(file = "Output/Tables and Plots/Fig_A5.jpeg",   # The directory you want to save the file in
     width = 800, # The width of the plot in inches
     height = 500) #
par(family="CMU Serif", mai=c(1,1,0.5,0.5))
plot(DD.data$StutzerOHNE[1:24],DD.data$Index[1:24], type = "n", bty="n",
     xlab="Stutzer Index", ylab="sub-national Direct Democracy Index (snDDI)")
text(DD.data$StutzerOHNE[1:24],DD.data$Index[1:24],
     labels =  DD.data$State[DD.data$country=="CH"],
     col=colL[3])
fit1 <- lm(DD.data$Index[1:24] ~ DD.data$StutzerOHNE[1:24])
abline(fit1, lwd=3, col=colL[1])
dev.off()

CL <- round(cor(DD.data$Index[1:24],DD.data$StutzerOHNE[1:24]),2)
cat(CL,file= "Output/Tables and Plots/correlation.tex")




# Plot all countries



#colorL <- c("blue","magenta", "purple", "red")
colorL <-rev(RColorBrewer::brewer.pal(4, "PuOr"))[c(4,2,3,1)]
countryL <- c("United States", "Austria", "Germany", "Switzerland")
DD.data$State[DD.data$State=="Meckenburg-Vorpommern"] <- "Mecklenburg-Vorpommern"




jpeg(file = "Output/Tables and Plots/Fig_1.jpeg",   
     width = 1400, 
     height = 800,
     pointsize = 20) #

par(mfrow=c(4,1), family="CMU Serif",xpd=TRUE)

layout(matrix(c(1,1,4,4,3,2), 2,3, byrow = FALSE),heights=c(2,1))

for (i in c("US","AT","DE", "CH")){
  data.pl <- DD.data[DD.data$country==i,]
  orderL <- order(data.pl$Average)
  
  plot(data.pl$Average[orderL],
       seq(0,3,length.out=length(data.pl$Average)), 
       yaxt = "n", 
       xlab=paste("snDDI", 
                  countryL[which(i==c("US","AT","DE", "CH"))]), 
       pch=20, 
       col=colorL[which(i==c("US","AT","DE", "CH"))], 
       ylab=" ", xlim=c(-0.1,2.1),
       bty="n", xpd= TRUE, cex.axis=1.5, cex.lab=1.5, cex=2.5)
  
  segments(0,seq(0,3,length.out=length(data.pl$Average)),
           data.pl$Average[orderL],
           seq(0,3,length.out=length(data.pl$Average)),
           col=colorL[which(i==c("US","AT","DE", "CH"))], 
           lwd=8)
  
  text(data.pl$Average[orderL]+0.05,
       seq(0,3,length.out=length(data.pl$Average)),
       data.pl$State[orderL],
       cex=1.2,pos = 4,
       col="black")
}
dev.off()








